<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/1999/REC-html401-19991224/strict.dtd">
<html>
<Head>
	<title>iPrint Printer Selection</title>
	
<!-- 
	University of Illinois/NCSA Open Source License for iprintlist.php.

Copyright (c) 2008 Jim Champ/Surrey County Council 
All rights reserved.
Developed by: 		Jim Champ
                    www.devboats.co.uk/idmphp/
Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal with the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimers. 

Redistributions in binary form must reproduce the above
copyright notice, this list of conditions and the following disclaimers
in the documentation and/or other materials provided with the
distribution. 

Neither the names of Surrey County Council nor the names of its contributors may be used to endorse
or promote products derived from this Software without specific prior
written permission. 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR
ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS WITH THE SOFTWARE. -->
	
</head>
<body>
<H1>iPrint Printer Selection</H1>

<div>

<h2>Each Building's Printer Selection Pages sorted <a href="#town">by Town</a> and by A-Z of <a href="#building">Building Name</a>.</h2>
<p>To find out how to locate and install printers read <a href="#instruct">How to find your printer</a>.</p>

<?php
// define an array of building records

$arrbrecords = array(array());

ReadInFile();

uasort($arrbrecords, 'sortTownBuilding');  

WriteLocallist();

print("<p><a name=\"town\"></a></p>");

writehtmllisttown();

uasort($arrbrecords, 'sortOnlyBuilding');  

print("<p><a name=\"building\"> </a></p>");

writehtmllistbuilding();

print ("<p></p>");

WriteInstructions();

print ("            </div>");

print ("         </div>");

die();

function WriteInstructions () {
	$instruct = "<h2><a name=\"instruct\">How to find your Printer</a></h2>\n";
	$instruct .= "<p>";
	$instruct .= "This page contains a list of all buildings where the self service iPrint printing system is now available.";
	$instruct .= " If it is available at your current location then the top of the page should say \"Nearest Buildings\", and ";
	$instruct .= " show an entry or two under that heading. Below that there is a list of Towns, with all the Buildings with ";
	$instruct .= "\"iPrint\"  printing available at that town listed. Then farther down there is a straightforward ";
	$instruct .=  "A-Z of the building names. You'll notice that some buildings appear more than once with different names. ";
	$instruct .= "This is because we know some of our buildings by more than one name and it all helps make things a little easier.";

	$instruct .= "</p>\n<p>";
	$instruct .=" When you've located the building you want to print at - and it can be somewhere else if you really want -";
	$instruct .="  then click on its link and you'll get to the building's own page. At this stage you may be prompted to install ";
	$instruct .="the client software for this printing system. If you are then please do so - otherwise it can't work.";
	$instruct .= "</p>\n<p>";

	$instruct .="When you get the building page up it will show you a list of printers, with on the left the name of the printer as it ";
	$instruct .="appears on the label on the printer, and in the middle the best description we could come up ";
	$instruct .=" with to give you an idea of where to find it. To install the printer then just click on the printer name ";
	$instruct .=" on the left: the printer will then be ";
	$instruct .="installed on your workstation, and you'll be able to select it from the printer controls of the application";
	$instruct .=" you are using.";
	$instruct .= "</p>\n<p>";
	$instruct .= "If this isn't clear or if you have any other questions please contact ";
	$instruct .= "the IT Support Desk."; 

	print($instruct);


}

function sortTownBuilding ($a,$b) {
	$keyindex1 = 0;
	$keyindex2 = 4;
	if ($a[$keyindex1] == $b[$keyindex1]) {
		return strcmp($a[$keyindex2], $b[$keyindex2]);  
		}  
	return ($a[$keyindex1] < $b[$keyindex1])? -1 : 1;  
}  

function SortOnlyBuilding ($a,$b) {
	$keyindex1 = 4;
	$keyindex2 = 0;
	if ($a[$keyindex1] == $b[$keyindex1]) {
		return strcmp($a[$keyindex2], $b[$keyindex2]);  
		}  
	return ($a[$keyindex1] < $b[$keyindex1])? -1 : 1;  
}  

function writehtmllistTown() {


	// OK well now we have this populated array with a bunch of records in
	// We need to sort it the way we want, then output is HTML

	// the various sorts are here...

	global $arrbrecords;
	reset($arrbrecords);
	$lastsite = "!!!&&***";
	$proutput = "";
	$prnavig = "<h2>Towns and Buildings</h2>\n<p>";
	$sort_idx = 0;
	// OK now the output
	// we are going to print each line as a list
	while(list($k, $v) = each($arrbrecords)) {
		// We are handling each row of the list in this loop
		// make sure we have some data...
		if(strlen(trim(implode('',$v))) > 0) {
			// we have passed all what for sake of argument we could call validation and have a record
			// in the array 
			// 0 is the town
			// 1 is the servername, 
			// 2 subnet
			// 3 notes
			// 4 building name

			// What we will do is split the list up town by town

			if($v[$sort_idx]==$lastsite) {
			} else {
				// we have a new whatever is in field $sort_idx...
				// So we print a town line and start a new list
				if ($lastsite != "!!!&&***") {
					// this is not our first record
					// we want to end the last list ready to start a new one
					$proutput .="      </ul>\n   </ul>\n";
					$prnavig .=" - ";
					}
									
				$prnavig .=" <a href=\"#".$v[$sort_idx]."\">".$v[$sort_idx]."</a> ";
				
				$proutput .="<ul class=\"\">\n";
				$proutput .="   <li>";
				$proutput .=" <a name=\"".$v[$sort_idx]."\">";
				$proutput .="<h3>" . $v[$sort_idx]."</h3>";
				$proutput .="</a></li>\n";

				$proutput .="   <ul class=\"\">\n";
				$lastsite = $v[$sort_idx];
			}
			$proutput .="      <li><a href=\"http://";
			$proutput .=$v[1];
			$proutput .="/ippdocs/pcontrol.htm\">";
			$proutput .=$v[4];
			$proutput .="</a></li>\n";
			$proutput .=" - ".$v[3] ."\n";
			}
		}
	$proutput .="   </ul>\n</ul\n";
	// $prnavig .=" - <a href=\"#instruct\">Instructions</a></p>\n";
	$prnavig .="</p>\n";
	print($prnavig);
	print($proutput);
}

function writehtmllistBuilding() {


	// OK well now we have this populated array with a bunch of records in
	// We need to sort it the way we want, then output is HTML

	// the various sorts are here...



	global $arrbrecords;
	reset($arrbrecords);
	$lastalpha = "!";
	$proutput = "";
	$prnavig = "<h2>A-Z of Buildings</h2>\n<p>";
	$sort_idx = 4;
	$alpha = "";

	// OK now the output
	// we are going to print each line as a list

	while(list($k, $v) = each($arrbrecords)) {
		// We are handling each row of the list in this loop
		// make sure we have some data...
		if(strlen(trim(implode('',$v))) > 0) {
			// we have passed all what for sake of argument we could call validation and have a record
			// in the array 
			// 0 is the town
			// 1 is the servername, 
			// 2 subnet
			// 3 notes
			// 4 building name

			// What we are aiming for here is an alphabetical list of buildings
				// no building, no alphanet entry


			$alpha = strtoupper(substr($v[$sort_idx],0,1)); 
	

			if($alpha == $lastalpha) {
			} else {
				// we have a new whatever is in field $sort_idx...
				// So we print a new alphabet line and start a new list
				if ($lastalpha != "!") {
					// this is not our first record
					// we want to end the last list ready to start a new one
					$proutput .="      </ul>\n   </ul>\n";
					$prnavig .=" - ";
					}
									
				$prnavig .=" <a href=\"#".$alpha."\">".$alpha."</a> ";
				$proutput .="<ul class=\"\">\n";
				$proutput .="<li>".  "<a name=\"".$alpha."\"><h3>" . $alpha . "</h3></a></li>\n";
				$proutput .="   <ul class=\"\">\n";
				$lastalpha = $alpha;
			}

			$proutput .="<li><a href=\"http://";
			$proutput .=$v[1];
			$proutput .="/ippdocs/pcontrol.htm\">";
			$proutput .=$v[4];
			}
		}

	$proutput .="   </ul>\n</ul>\n";
	$prnavig .=" - <a href=\"#instruct\">Instructions</a></p>\n";
	print($prnavig);
	print($proutput);
}

function WriteLocallist() {
	// in this we will compare the workstation ip address
	// with that of all the server


	global $arrbrecords;
	reset($arrbrecords);
	
	// OK now the output
	// we are going to print each line as a list
	
	$workstationaddr = $_SERVER['REMOTE_ADDR'];
	$localflag = false;
	$thead = "Nearest Buildings";
	$locallist = ("<h2>" . $thead . "</h2>\n");
	$locallist .= ("<ul class=\"\">\n");
	while(list($k, $v) = each($arrbrecords)) {
		// We are handling each row of the list in this loop
		// make sure we have some data...
		if(strlen(trim(implode('',$v))) > 0) {
			// we have passed all what for sake of argument we could call validation and have a record
			// in the array 
			// 0 is the town
			// 1 the servername, 
			// 2 subnet
			// 3 notes
			// 4 building name

			// look for a macth with the subnet names
			if(substr($workstationaddr,0,strlen($v[2]))==$v[2]) {
				// theres a match between declared subnet of this site and the calling workstation
				$locallist .= ("<li><a href=\"http://");
				$locallist .= ($v[1]);
				$locallist .= ("/ippdocs/pcontrol.htm\">");
				$locallist .= ($v[4]);
				$locallist .= ("</a></li>\n");
				$locallist .= (" - ".$v[3] ."\n");
				$localflag = true;
				}
			}
		}
	if ($localflag == true) {

		print($locallist);
		print("</ul>\n");

	}
}

function ReadinFile() {


	global $arrbrecords;

	$arrholder = array();
	$arrptr = 0;

	//First we open the php file

	$handle = fopen("iprintsites.csv", "r");
	
	// the first line in the file is the variables so we just read and discard
	// Server,Town,IPSubnet,Notes,BuildingName1,BuildingName2,BuildingName3

	$buffer = fgets($handle, 4096);
	while (!feof($handle)) {
		$arr_buffer = fgetcsv($handle, 4096);
		// for each of the three building aliases in the line we want to create a record in arr-brecords
		// that is provided that there is a building recorded...
		// we always test and that way handle blank records in teh file...
		// also we need to allow for their not being enough fields...
		$numrecs = count($arr_buffer);
	
		// there should be 7 records
		if ($numrecs > 6) {
			// then we have a potentially good line with at least 7 records and continue processing it in here
			// so we look at each record and see if its OK...
			// we want a good server[0], town[1] and ipsubnet[2]
			if (strlen(trim($arr_buffer[0])) < 3) { 
				continue;
			}
			if (strlen(trim($arr_buffer[1])) < 3) { 
				continue;
			}
			if (strlen(trim($arr_buffer[2])) < 3) { 
				continue;
			}
			
			// in order to get round Excel's habit of droppiong traling zeros
			// the ubnet [2] field startes with the text string subnet
			// so we drop the left 5 chars and get the rest.
			

			
			// OK we've done crude validation and reckon we've got some records
			// now for each possible town name we put data in the array

			if (strlen(trim($arr_buffer[4])) > 2) {
				// we have some sorta town name in this record
				// so we push data in the array
				$arrbrecords[$arrptr][0] = trim($arr_buffer[0]);
				$arrbrecords[$arrptr][1] = trim($arr_buffer[1]);
				$arrbrecords[$arrptr][2] = trim(substr($arr_buffer[2],6));
				$arrbrecords[$arrptr][3] = trim($arr_buffer[3]);
				$arrbrecords[$arrptr][4] = trim($arr_buffer[4]);
				$arrptr=$arrptr+1;
			}
			if (strlen(trim($arr_buffer[5])) > 2) {
				// we have some sorta town name in this second record too
				// so we push data in the array
				$arrbrecords[$arrptr][0] = trim($arr_buffer[0]);
				$arrbrecords[$arrptr][1] = trim($arr_buffer[1]);
				$arrbrecords[$arrptr][2] = trim(substr($arr_buffer[2],6));
				$arrbrecords[$arrptr][3] = trim($arr_buffer[3]);
				$arrbrecords[$arrptr][4] = trim($arr_buffer[5]);
				$arrptr=$arrptr+1;
			}
			if (strlen(trim($arr_buffer[6])) > 2) {
				// we have some sorta town name in this record
				// so we push data in the array
				$arrbrecords[$arrptr][0] = trim($arr_buffer[0]);
				$arrbrecords[$arrptr][1] = trim($arr_buffer[1]);
				$arrbrecords[$arrptr][2] = trim(substr($arr_buffer[2],6));
				$arrbrecords[$arrptr][3] = trim($arr_buffer[3]);
				$arrbrecords[$arrptr][4] = trim($arr_buffer[6]);
				$arrptr=$arrptr+1;
			}


		} else {
			// we got here because we didn't have 6 records in teh line of CSV
			// so we do nothing and continue
		}
	    	
	}
	fclose($handle);


}
?> 
</div>
</body>
</html>